using System;
using System.Collections.Generic;
using System.Text;

namespace Microsoft.Practices.EnterpriseLibrary.Configuration.Factory
{
    public abstract class ObjectFactoryBase<TObjectToCreate, TObjectConfiguration> : IObjectFactory<TObjectToCreate, TObjectConfiguration>
    {
        #region IObjectFactory<TObjectToCreate,TObjectConfiguration> Members

        public virtual TObjectToCreate Create(TObjectConfiguration objectConfiguration)
        {
            return Create(objectConfiguration, new SystemConfigurationSource());
        }

        public abstract TObjectToCreate Create(TObjectConfiguration objectConfiguration, IConfigurationSource configurationSource);

        #endregion
}
}
